(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8961,        281]*)
(*NotebookOutlinePosition[      9800,        308]*)
(*  CellTagsIndexPosition[      9756,        304]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(NIntegrate[2/\((2 + Sin[10\ \[Pi]\ x])\), \ {x, \ 0, \ 1}]\)], "Input"],

Cell[BoxData[
    \(1.15470053838386443`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\( (*\ Trapezoidal\ rule\ with\ 12\ intervals\ of\ length\ 1/12\ *) \ 
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x_] := \ 2/\((2 + Sin[10\ \[Pi]\ x])\); \n
    \(\((1/12)\)*\((f[1/12] + f[1])\) + 
          \((1/6)\)*\ 
            \((\ f[1/6] + \ f[1/4]\  + \ f[1/3] + \ f[5/12] + \ f[1/2] + 
                f[7/12] + f[2/3] + f[3/4] + f[5/6] + f[11/12])\) // N\) // 
      Simplify\)], "Input"],

Cell[BoxData[
    \(2.15940170940170927`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ Gauss - Legendre\ quadrature\ with\ 12\ points; \n\t
      Note\ that\ integral = sum\ w_i\ f \((\[Xi]_i)\)\ \ *) \)], "Input"],

Cell[BoxData[
    \( (*\ To\ find\ 12\ Gauss\ points\ for\ the\ interval\ \((0, 1)\), \ 
      we\ start\ with\ the\ interval\ \((\(-1\), 1)\), \ 
      and\ then\ use\ the\ formula\ \ \[Xi]_i = 
        \((1 + x_i)\)/2\ \n\tSee\ gausspoints . nb\ also\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[LegendreP[12, x] == 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] \(-0.981560634246731922`\)}, {
        x \[Rule] \(-0.904117256370451727`\)}, {
        x \[Rule] \(-0.769902674194317793`\)}, {
        x \[Rule] \(-0.587317954286614352`\)}, {
        x \[Rule] \(-0.367831498998180439`\)}, {
        x \[Rule] \(-0.125233408511468891`\)}, {
        x \[Rule] 0.125233408511468891`}, {x \[Rule] 0.367831498998180439`}, {
        x \[Rule] 0.587317954286614352`}, {x \[Rule] 0.769902674194317793`}, {
        x \[Rule] 0.904117256370451727`}, {x \[Rule] 0.981560634246731922`}}
      \)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      These\ are\ Gauss\ points\ \[Xi]_i\ for\ the\ interval\ 
        \((\(-1\), 1)\)\ *) \)], "Input"],

Cell[BoxData[
    \(\(gausspoints = {\(-0.981560634246731922`\), 
        \(-0.904117256370451727`\), \(-0.769902674194317793`\), 
        \(-0.587317954286614352`\), \(-0.367831498998180439`\), 
        \(-0.125233408511468891`\), 0.125233408511468891`, 
        0.367831498998180439`, 0.587317954286614352`, 0.769902674194317793`, 
        0.904117256370451727`, 0.981560634246731922`}; \)\)], "Input"],

Cell[BoxData[
    \( (*\ Now\ to\ obtain\ gausspoints\ for\ \((0, 1)\)\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[a_] := \((1 + a)\)/2\ ; \n
    newgausspoints = 
      Map[g, {\(-0.981560634246731922`\), \(-0.904117256370451727`\), 
          \(-0.769902674194317793`\), \(-0.587317954286614352`\), 
          \(-0.367831498998180439`\), \(-0.125233408511468891`\), 
          0.125233408511468891`, 0.367831498998180439`, 
          0.587317954286614352`, 0.769902674194317793`, 
          0.904117256370451727`, 0.981560634246731922`}]\)], "Input"],

Cell[BoxData[
    \({0.0092196828766340495`, 0.0479413718147741452`, 0.115048662902841103`, 
      0.206341022856692823`, 0.31608425050090978`, 0.43738329574426551`, 
      0.562616704255734401`, 0.683915749499090175`, 0.793658977143307176`, 
      0.88495133709715894`, 0.952058628185225863`, 0.990780317123365961`}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Xi]1 = 0.0092196828766340495`; \n\[Xi]2 = 0.0479413718147741452`; \n
    \[Xi]3 = 0.115048662902841103`; \n\[Xi]4 = 0.206341022856692823`; \n
    \[Xi]5 = 0.31608425050090978`; \n\[Xi]6 = 0.43738329574426551`; \n
    \[Xi]7 = 0.562616704255734401`; \n\[Xi]8 = 0.683915749499090175`; \n
    \[Xi]9 = 0.793658977143307176`; \n\[Xi]10 = 0.88495133709715894`; \n
    \[Xi]11 = 0.952058628185225863`; \n\[Xi]12 = 0.990780317123365961`; \n
    w1 = 0.0471753364; \nw2 = 0.1069393260; \nw3 = 0.1600783285; \n
    w4 = 0.2031674267; \nw5 = 0.2334925365; \nw6 = 0.2491470458; \n
    w7 = 0.2491470458; \nw8 = 0.2334925365; \nw9 = 0.2031674267; \n
    w10 = 0.1600783285; \nw11 = 0.1069393260; \nw12 = 0.0471753364; \n
    w1*f[\[Xi]1] + w2*f[\[Xi]2] + w3*f[\[Xi]3] + w4*f[\[Xi]4] + 
      w5*f[\[Xi]5] + w6*f[\[Xi]6] + w7*f[\[Xi]7] + w8*f[\[Xi]8] + 
      w9*f[\[Xi]9] + w10*f[\[Xi]10] + w11*f[\[Xi]11] + w12*f[\[Xi]12]\)], 
  "Input"],

Cell[BoxData[
    \(2.25809159115168478`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[2/\((2 + Sin[10\ \[Pi]\ x])\), \ {x, \ 0, \ 1}]\)], "Input"],

Cell[BoxData[
    \(2\/\@3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \(1.15470053837925168`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ Trapezoidal\ 4 - \(point : \ the\ points\ are\ 0\), \ 1/4, \ 1/2, 
      \ 3/4, \ 1. \ Then\ h = 1/4*) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integral1 = \((1/4)\)*\((f[1/4] + 2\ f[1/2] + 2\ f[3/4] + f[1])\)\)], 
  "Input"],

Cell[BoxData[
    \(23\/12\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \(1.91666666666666678`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Trapezoidal\ 12 - point\ *) \n
    integral2 = 
      \((1/12)\)*
        \((f[1/12] + 2\ f[2/12] + 2\ f[3/12] + 2\ f[4/12] + 2\ f[5/12] + 
            2\ f[6/12] + 2\ f[7/12] + 2\ f[8/12] + \ 2\ f[9/12] + 
            2\ f[10/12] + \ 2\ f[11/12] + \ f[1])\)\)\)], "Input"],

Cell[BoxData[
    \(1\/12\ \((241\/15 + 8\/\(2 - \@3\/2\) + 8\/\(2 + \@3\/2\))\)\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \(2.15940170940170927`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 4 - point\ Gauss - Legendre\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[LegendreP[4, x] == 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] \(-0.86113631159405255`\)}, {
        x \[Rule] \(-0.339981043584856257`\)}, {
        x \[Rule] 0.339981043584856257`}, {x \[Rule] 0.86113631159405255`}}
      \)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(gausspts = {\(-0.86113631159405255`\), \(-0.339981043584856257`\), 
        0.339981043584856257`, 0.86113631159405255`}\)], "Input"],

Cell[BoxData[
    \( (*These\ are\ gausspoints\ for\ the\ interval\ \((\(-1\), 1)\) . \ To\ 
        change\ them\ for\ thecinterval\ \((0, 1)\)\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(h[a_] := \((1 + a)\)/2\ ; \n
    newgausspts = 
      Map[h, {\(-0.86113631159405255`\), \(-0.339981043584856257`\), 
          0.339981043584856257`, 0.86113631159405255`}]\)], "Input"],

Cell[BoxData[
    \({0.0694318442029737159`, 0.330009478207571849`, 0.66999052179242815`, 
      0.930568155797026186`}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ These\ are\ gauspts\ for\ the\ interval\ \((0, 1)\)\ *) \)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Xi]1 = 0.0694318442029737159`; \n\[Xi]2 = 0.330009478207571849`; \n
    \[Xi]3 = 0.66999052179242815`; \n\[Xi]4 = 0.930568155797026186`; \n
    w1 = 0.3399810436; \nw2 = 0.6521451549; \nw3 = 0.8611363116; \n
    w4 = 0.3478548451; \n
    integral3 = w1*f[\[Xi]1] + w2*f[\[Xi]2] + w3*f[\[Xi]3] + w4*f[\[Xi]4]\)], 
  "Input"],

Cell[BoxData[
    \(2.53883205593260319`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{531, 440},
WindowMargins->{{4, Automatic}, {Automatic, -2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 91, 1, 27, "Input"],
Cell[1825, 54, 54, 1, 26, "Output"]
}, Open  ]],
Cell[1894, 58, 110, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[2029, 64, 306, 6, 107, "Input"],
Cell[2338, 72, 54, 1, 26, "Output"]
}, Open  ]],
Cell[2407, 76, 152, 2, 43, "Input"],
Cell[2562, 80, 270, 4, 75, "Input"],

Cell[CellGroupData[{
Cell[2857, 88, 67, 1, 27, "Input"],
Cell[2927, 91, 563, 10, 71, "Output"]
}, Open  ]],
Cell[3505, 104, 130, 3, 27, "Input"],
Cell[3638, 109, 404, 6, 123, "Input"],
Cell[4045, 117, 88, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[4158, 122, 459, 8, 139, "Input"],
Cell[4620, 132, 333, 5, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4990, 142, 948, 14, 443, "Input"],
Cell[5941, 158, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6032, 164, 90, 1, 27, "Input"],
Cell[6125, 167, 40, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6202, 173, 37, 1, 27, "Input"],
Cell[6242, 176, 54, 1, 26, "Output"]
}, Open  ]],
Cell[6311, 180, 141, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[6477, 186, 101, 2, 27, "Input"],
Cell[6581, 190, 40, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6658, 196, 37, 1, 27, "Input"],
Cell[6698, 199, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6789, 205, 300, 6, 75, "Input"],
Cell[7092, 213, 97, 2, 74, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7226, 220, 37, 1, 27, "Input"],
Cell[7266, 223, 54, 1, 26, "Output"]
}, Open  ]],
Cell[7335, 227, 70, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[7430, 232, 66, 1, 27, "Input"],
Cell[7499, 235, 207, 4, 26, "Output"]
}, Open  ]],
Cell[7721, 242, 153, 2, 59, "Input"],
Cell[7877, 246, 162, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[8064, 252, 206, 4, 75, "Input"],
Cell[8273, 258, 133, 2, 26, "Output"]
}, Open  ]],
Cell[8421, 263, 97, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[8543, 269, 345, 6, 155, "Input"],
Cell[8891, 277, 54, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

